<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Component\JLForm\Site\Helper\FormHelper;
use Joomla\Registry\Registry;

/**
 * @var  $displayData array
 * @var  $options     Registry
 * @var  $formParams  Registry
 */
$options    = $displayData['options'];
$formParams = $displayData['formParams'];
$format     = $options->get('format');

if ($format === 'number' || $format === 'email') {
    $displayData['ctrlAttrs']['data-text-format'] = $format;

    if ($format === 'number') {
        if ($options->get('integer')) {
            $displayData['ctrlAttrs']['data-number-integer'] = '';
        }

        if (is_numeric($min = $options->get('minimum'))) {
            $displayData['ctrlAttrs']['min'] = $min;
        }

        if (is_numeric($max = $options->get('maximum'))) {
            $displayData['ctrlAttrs']['max'] = $max;
        }
    }
} elseif ($format === 'text') {
    if (is_numeric($minLength = $options->get('minLength'))) {
        $displayData['ctrlAttrs']['minlength'] = $minLength;
    }

    if (is_numeric($maxLength = $options->get('maxLength'))) {
        $displayData['ctrlAttrs']['maxlength'] = $maxLength;
    }
} elseif ($format === 'password') {
    $displayData['ctrlAttrs']['autocomplete'] = 'new-password';
}

if ($regex = trim($options->get('pattern', ''))) {
    $displayData['ctrlAttrs']['pattern'] = $regex;
}

$isBootstrapLayout                 = $formParams->get('formLayout', 'bootstrap') === 'bootstrap';
$ctrlClass                         = $isBootstrapLayout ? 'form-control' : 'uk-input';
$ctrlSmallClass                    = $isBootstrapLayout ? 'form-control-sm' : 'uk-form-small';
$ctrlLargeClass                    = $isBootstrapLayout ? 'form-control-lg' : 'uk-form-large';
$displayData['ctrlAttrs']['class'] .= ' ' . $ctrlClass . ($formParams->get('controlSize') === 'small' ? ' ' . $ctrlSmallClass : ($formParams->get('controlSize') === 'large' ? ' ' . $ctrlLargeClass : ''));
$value                             = $displayData['value'] ?? '';
?>

<?php if ($format === 'freeText') : ?>
    <div class="jl-form-free-text"<?php echo empty($displayData['ctrlAttrs']['data-show-on']) ? '' : ' data-show-on="' . htmlspecialchars($displayData['ctrlAttrs']['data-show-on']) . '"'; ?>>
        <?php echo $options->get('freeText'); ?>
    </div>

<?php else : ?>
    <input
            name="<?php echo $displayData['name'] ?>"
            type="<?php echo $format; ?>"
            value="<?php echo htmlspecialchars($value); ?>"
        <?php echo FormHelper::buildAttributes($displayData['ctrlAttrs']); ?>
    />

<?php endif; ?>
