<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Component\JLForm\Site\Helper\FormHelper;
use Joomla\Registry\Registry;

/**
 * @var  $displayData array
 * @var  $options     Registry
 * @var  $formParams  Registry
 */
$options    = $displayData['options'];
$formParams = $displayData['formParams'];

if (is_numeric($rows = $options->get('rows'))) {
    $displayData['ctrlAttrs']['rows'] = $rows;
}

if (is_numeric($cols = $options->get('cols'))) {
    $displayData['ctrlAttrs']['cols'] = $cols;
}

if ($regex = trim($options->get('pattern', ''))) {
    $displayData['ctrlAttrs']['pattern'] = $regex;
}

if (is_numeric($minLength = $options->get('minLength'))) {
    $displayData['ctrlAttrs']['minlength'] = $minLength;
}

if (is_numeric($maxLength = $options->get('maxLength'))) {
    $displayData['ctrlAttrs']['maxlength'] = $maxLength;
}

$isBootstrapLayout                 = $formParams->get('formLayout', 'bootstrap') === 'bootstrap';
$ctrlClass                         = $isBootstrapLayout ? 'form-control' : 'uk-textarea';
$ctrlSmallClass                    = $isBootstrapLayout ? 'form-control-sm' : 'uk-form-small';
$ctrlLargeClass                    = $isBootstrapLayout ? 'form-control-lg' : 'uk-form-large';
$displayData['ctrlAttrs']['class'] .= ' ' . $ctrlClass . ($formParams->get('controlSize') === 'small' ? ' ' . $ctrlSmallClass : ($formParams->get('controlSize') === 'large' ? ' ' . $ctrlLargeClass : ''));
$value                             = $displayData['value'] ?? '';
?>

<textarea name="<?php echo $displayData['name'] ?>"<?php echo FormHelper::buildAttributes($displayData['ctrlAttrs']); ?>><?php echo $value; ?></textarea>