<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Component\JLForm\Site\Helper\FormHelper;
use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;
use Joomla\Registry\Registry;


/**
 * @var  $displayData array
 * @var  $options     Registry
 * @var  $formParams  Registry
 */

extract($displayData);
AssetHelper::getWebAssetManager()->usePreset('joomlab.calendar');
$isBootstrapLayout                            = $formParams->get('formLayout', 'bootstrap') === 'bootstrap';
$ctrlClass                                    = $isBootstrapLayout ? 'form-control' : 'uk-input';
$ctrlSmallClass                               = $isBootstrapLayout ? 'form-control-sm' : 'uk-form-small';
$ctrlLargeClass                               = $isBootstrapLayout ? 'form-control-lg' : 'uk-form-large';
$displayData['ctrlAttrs']['class']            .= $ctrlClass . ($formParams->get('controlSize') === 'small' ? ' ' . $ctrlSmallClass : ($formParams->get('controlSize') === 'large' ? ' ' . $ctrlLargeClass : ''));
$displayData['ctrlAttrs']['data-jl-calendar'] = json_encode([
    'timeOnly' => true,
    'time24'   => $options->get('format24h', true),
    'inline'   => $options->get('inline', false),
]);
?>
<div class="jl-form__field-time">
    <input
            type="text"
            name="<?php echo htmlspecialchars($name); ?>"
            name="<?php echo htmlspecialchars($displayData['value'] ?? ''); ?>"
        <?php echo FormHelper::buildAttributes($displayData['ctrlAttrs']); ?>
    />
</div>
