<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * @var array    $displayData
 * @var array    $paymentsList
 * @var stdClass $form
 */

extract($displayData);
?>

<ul class="jl-form__payments-list">
    <?php foreach ($paymentsList as $i => $payment): ?>
        <li>
            <label>
                <input name="JLForm[__payment]" type="radio" value="<?php echo htmlspecialchars($payment['name']); ?>"/>
                <?php echo $payment['display']; ?>
            </label>
        </li>
    <?php endforeach; ?>
</ul>

<div class="jl-form__field-container__messages">
    <?php if ($form->params->get('formLayout', 'bootstrap') === 'bootstrap'): ?>
        <div class="jl-form__payments-message text-danger js-invalid-feedback" hidden></div>
    <?php else: ?>
        <div class="jl-form__payments-message uk-text-danger js-invalid-feedback" hidden></div>
    <?php endif; ?>
</div>
