<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSWebApplicationInterface;
use Joomla\CMS\Form\FormFactoryInterface;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\Component\JLForm\Administrator\Controller\SubmissionController as AdminController;
use Joomla\Input\Input;

class SubmissionController extends AdminController
{
    public function __construct($config = [], ?MVCFactoryInterface $factory = null, ?CMSWebApplicationInterface $app = null, ?Input $input = null, ?FormFactoryInterface $formFactory = null)
    {
        parent::__construct($config, $factory, $app, $input, $formFactory);
        $this->app->getLanguage()->load('com_jlform', JPATH_ADMINISTRATOR . '/components/com_jlform');
    }

    public function getModel($name = 'Submission', $prefix = 'Administrator', $config = ['ignore_request' => true])
    {
        return parent::getModel($name, $prefix, $config);
    }

    public function allowEdit($data = [], $key = 'id')
    {
        $pk    = (int)($data[$key] ?? 0);
        $table = $this->factory->createTable('Submission', 'Administrator');
        $table->load($pk);

        return $table->createdBy == $this->app->getIdentity()->id;
    }

    protected function getRedirectToItemAppend($recordId = null, $urlVar = 'id')
    {
        $result = parent::getRedirectToItemAppend($recordId, $urlVar);

        if ($itemId = $this->input->getUint('Itemid')) {
            $result .= '&Itemid=' . $itemId;
        }

        return $result;
    }

    protected function getRedirectToListAppend()
    {
        $result = parent::getRedirectToListAppend();

        if ($itemId = $this->input->getUint('Itemid')) {
            $result .= '&Itemid=' . $itemId;
        }

        return $result;
    }
}