<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Event;

defined('_JEXEC') or die;
class BeforeSubmitEvent extends FormEvent
{
    public function __construct(array $arguments = [])
    {
        parent::__construct(static::BEFORE_SUBMIT, $arguments);
    }

    public function getValidData(): array
    {
        return $this->getArgument('validData');
    }

    public function getRedirect(): ?string
    {
        return $this->getArgument('redirect');
    }

    public function setRedirect(string $uri): static
    {
        $this->setArgument('redirect', $uri);

        return $this;
    }

    public function addError(string $error): static
    {
        return $this->setErrors(array_merge($this->getErrors(), [$error]));
    }

    public function setErrors(array $errors): static
    {
        $this->setArgument('errors', $errors);

        return $this;
    }

    public function getErrors(): array
    {
        return $this->getArgument('errors', []);
    }
}
