<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Event;

defined('_JEXEC') or die;

use Joomla\Component\JLForm\Administrator\Table\SubmissionTable;
use Joomla\Event\Event;
use stdClass;

class PaymentAmountEvent extends Event
{
    public function getForm(): stdClass
    {
        return $this->getArgument('subject');
    }

    public function getSubmission(): SubmissionTable
    {
        return $this->getArgument('submission');
    }

    public function getAmount(): int|float
    {
        return $this->getArgument('amount');
    }

    public function getCurrency(): string
    {
        return $this->getArgument('currency');
    }

    public function getPaymentName(): string
    {
        return $this->getArgument('paymentName');
    }

    public function setAmount(int|float $amount): static
    {
        $this->setArgument('amount', $amount);

        return $this;
    }

    public function allowPayOnSubmissionPage(bool $allow = true): static
    {
        $this->setArgument('allowPayOnSubmissionPage', $allow);

        return $this;
    }

    public function isAllowPayOnSubmissionPage(): bool
    {
        return (bool)$this->getArgument('allowPayOnSubmissionPage', false);
    }
}