<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Helper\FieldValidator;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\Component\JLForm\Site\Helper\FieldValidator;
use Joomla\Component\JLForm\Site\Helper\FormHelper;
use Joomla\Plugin\System\Joomlab\Helper\UtilityHelper;

class ListFieldBase extends FieldValidator
{
    protected function doValidate(&$value)
    {
        $validValues = [];

        foreach ($this->options->get('items', []) as $item) {
            $optionDefault = FormHelper::_($item, true);
            $optionNative  = FormHelper::_($item);
            $jsonNative    = UtilityHelper::parseJson($optionNative);
            $jsonDefault   = UtilityHelper::parseJson($optionDefault);
            $validValues[] = $jsonNative['val'] ?? $jsonDefault['val'] ?? $optionNative;
        }

        $slicedValues = implode(', ', array_slice($validValues, 0, 5));

        if ($this->options->get('multiple') || $this->type === 'CheckList') {
            if (!is_array($value)) {
                $this->addError(Text::_('COM_JLFORM_ERR_FIELD_INVALID_ARRAY_MSG'));

                return false;
            }

            foreach ($value as $val) {
                if (!in_array($val, $validValues, true)) {
                    $this->addError(Text::sprintf('COM_JLFORM_ERR_FIELD_INVALID_LIST_VALUE_MSG', $slicedValues));
                    break;
                }
            }
        } elseif (!in_array($value, $validValues, true)) {
            $this->addError(Text::sprintf('COM_JLFORM_ERR_FIELD_INVALID_LIST_VALUE_MSG', $slicedValues));
        }
    }
}
