<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Helper\FieldValidator;

use Joomla\CMS\Filter\InputFilter;

defined('_JEXEC') or die;

class TextAreaField extends TextFieldBase
{
    public function getValue()
    {
        $tagsArray = [
            'a',
            'b',
            'strong',
            'code',
            'del',
            'dd',
            'div',
            'dl',
            'dt',
            'em',
            'h1',
            'h2',
            'h3',
            'h4',
            'h5',
            'h6',
            'i',
            'kbd',
            'li',
            'ol',
            'p',
            'pre',
            's',
            'span',
            'sub',
            'sup',
            'strong',
            'ul',
            'br',
            'hr',
        ];
        $attrArray = ['style'];

        return trim(InputFilter::getInstance($tagsArray, $attrArray)->clean($this->value, 'HTML'));
    }
}
