<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Helper\FieldValidator;

defined('_JEXEC') or die;

use Joomla\CMS\Filter\InputFilter;
use Joomla\CMS\Language\Text;
use Joomla\Component\JLForm\Site\Helper\FieldValidator;

class TextFieldBase extends FieldValidator
{
    protected ?string $dataType = 'string';

    public function validate(&$value = null): bool
    {
        if ($this->options->get('format', 'text') === 'freeText') {
            $value = null;

            return true;
        }

        if ($this->options->get('format', 'text') === 'number') {
            $this->dataType = 'number';

            if ($this->options->get('integer')) {
                if (false === filter_var($value, FILTER_VALIDATE_INT)) {
                    $this->addError(Text::_('COM_JLFORM_ERR_FIELD_INVALID_INTEGER_MSG'));

                    return false;
                }

                $value = (int)$value;
            }
        }

        return parent::validate($value);
    }

    public function getValue()
    {
        return trim(InputFilter::getInstance()->clean($this->value, 'HTML'));
    }

    protected function doValidate(&$value)
    {
        if ($this->options->get('format') === 'email' && !filter_var($value, FILTER_VALIDATE_EMAIL)) {
            $this->addError(Text::_('COM_JLFORM_ERR_FIELD_INVALID_EMAIL_MSG'));

            return false;
        }
    }
}
