<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Service;

defined('_JEXEC') or die;

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Component\Router\RouterView;
use Joomla\CMS\Component\Router\RouterViewConfiguration;
use Joomla\CMS\Component\Router\Rules\MenuRules;
use Joomla\CMS\Component\Router\Rules\NomenuRules;
use Joomla\CMS\Component\Router\Rules\StandardRules;
use Joomla\CMS\Menu\AbstractMenu;
use Joomla\Event\Event;

class Router extends RouterView
{
    public function __construct(SiteApplication $app, AbstractMenu $menu)
    {
        // Form view
        $form = new RouterViewConfiguration('form');
        $form->setKey('id');
        $this->registerView($form);

        // Submissions view
        $submissions = new RouterViewConfiguration('submissions');
        $this->registerView($submissions);
        $app->getDispatcher()
            ->dispatch('onJLFormInitRouter', new Event('onJLFormInitRouter', ['subject' => $this]));

        parent::__construct($app, $menu);

        $this->attachRule(new MenuRules($this));
        $this->attachRule(new StandardRules($this));
        $this->attachRule(new NomenuRules($this));
    }

    public function getFormSegment($id, $query)
    {
        return [(int)$id => $id];
    }

    public function getFormId($segment, $query)
    {
        return (int)$segment;
    }

    public function build(&$query)
    {
        $segments = parent::build($query);

        if (!empty($query['Itemid'])
            && !empty($query['id'])
            && ($menu = $this->menu->getItem($query['Itemid']))
            && ($menu->query['view'] ?? '') === 'submissions'
            && ($query['view'] ?? '') === 'submission'
        ) {
            $segments[] = (int)$query['id'];
            unset($query['view'], $query['id']);

            if (isset($query['layout'])) {
                unset($query['layout']);
            }
        }

        return $segments;
    }

    public function parse(&$segments)
    {
        $vars = parent::parse($segments);

        if (count($segments) === 1
            && is_numeric($segments[0])
            && ($menu = $this->menu->getActive())
            && ($menu->query['view'] ?? '') === 'submissions'
        ) {
            $vars['view']   = 'submission';
            $vars['layout'] = 'edit';
            $vars['id']     = (int)$segments[0];
            unset($segments[0]);
        }

        return $vars;
    }
}
