<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\Component\JLForm\Site\Helper\FormHelper;
use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;

$wa = AssetHelper::getWebAssetManager();
$wa->getRegistry()
    ->addRegistryFile('media/com_jlform/joomla.asset.json');

$app = Factory::getApplication();
$app->getLanguage()
    ->load('com_jlform', JPATH_SITE . '/components/com_jlform');

/**
 * @var Joomla\Registry\Registry $params
 * @var object                   $module
 */

$formBuffer = FormHelper::renderForm((int)$params->get('formId'));

if ($introText = trim($params->get('introText', ''))) {
    echo '<div class="mod-jlform-form-intro">' . $introText . '</div>';
}

if ($params->get('displayInModal', '0')) {
    $btnText = $params->get('modalButtonText') ?: Text::_('MOD_JLFORM_FORM_MODAL_BUTTON_TEXT_DEFAULT');
    $target  = '#mod-jlform__modal-link' . ($module->id ?: time());
    $attr    = htmlspecialchars(json_encode(['target' => $target, 'cls' => $params->get('modalSize', 'large') . ' vh']));
    $wa->usePreset('joomlab.core');
    $app->getDocument()
        ->addScriptDeclaration('document.addEventListener("DOMContentLoaded", () => Joomlab.modal.init());');

    echo '<div data-joomlab-modal="' . $attr . '" hidden>' . $formBuffer . '</div>'
        . '<a class="btn btn-primary" href="' . $target . '">' . htmlspecialchars($btnText) . '</a>';
} else {
    echo $formBuffer;
}