<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\Privacy\JLForm\Extension;

defined('_JEXEC') or die;


use Joomla\CMS\Language\Text;
use Joomla\Component\Privacy\Administrator\Plugin\PrivacyPlugin;
use Joomla\Event\AbstractEvent;
use Joomla\Event\SubscriberInterface;

final class JLForm extends PrivacyPlugin implements SubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            'onPrivacyExportRequest'            => 'onPrivacyExportRequest',
            'onPrivacyCollectAdminCapabilities' => 'onPrivacyCollectAdminCapabilities',
        ];
    }

    public function onPrivacyCollectAdminCapabilities(AbstractEvent $event)
    {
        $this->loadLanguage('com_jlform.sys', JPATH_ADMINISTRATOR . '/components/com_jlform');
        $result   = $event->getArgument('result', []);
        $result[] = [
            Text::_('COM_JLFORM') => [
                Text::_('PLG_PRIVACY_JLFORM_ACTIONS_1'),
            ],
        ];

        $event->setArgument('result', $result);
    }

    public function onPrivacyExportRequest(AbstractEvent $event)
    {
        $user = $event->getArgument('user', $event->getArgument(1));

        if (!$user) {
            return [];
        }

        $domains = [];
        $tables  = [
            'joomlab_form_submissions',
            'joomlab_form_submission_replies',
            'joomlab_form_submission_payments',
            'joomlab_form_submission_payment_activities',
        ];

        $db = $this->getDatabase();

        foreach ($tables as $table) {
            $domain    = $this->createDomain($table, $table . '_data');
            $domains[] = $domain;
            $query     = $db->getQuery(true)
                ->select('*')
                ->from($db->quoteName('#__' . $table))
                ->where($db->quoteName('createdBy') . ' = ' . (int)$user->id)
                ->order($db->quoteName('createdDate') . ' ASC');

            $items = $db->setQuery($query)->loadObjectList();

            foreach ($items as $item) {
                $domain->addItem($this->createItemFromArray((array)$item));
            }
        }

        $result   = $event->getArgument('result', []);
        $result[] = $domains;
        $event->setArgument('result', $result);
    }
}
