<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Administrator\Helper;

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseInterface;
use Joomla\Database\ParameterType;

defined('_JEXEC') or die;

class FormHelper
{
    public static function getFormFields(int $formId): array
    {
        static $fields = [];

        if (!isset($fields[$formId])) {
            $fields[$formId] = [];
            /** @var DatabaseInterface $db */
            $db    = Factory::getContainer()->get(DatabaseInterface::class);
            $query = $db->getQuery(true)
                ->select('a.data')
                ->from($db->quoteName('#__joomlab_forms', 'a'))
                ->where('a.id = :id')
                ->bind(':id', $formId, ParameterType::INTEGER);

            if ($data = $db->setQuery($query)->loadResult()) {
                $steps = json_decode($data, true);
                foreach ($steps as $step) {
                    foreach ($step['rows'] as $row) {
                        foreach ($row as $col) {
                            foreach ($col['data'] as $field) {
                                if ($name = $field['general']['name'] ?? null) {
                                    $fields[$formId][$name] = $field;
                                }
                            }
                        }
                    }
                }
            }
        }

        return $fields[$formId];
    }
}
