<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Router\Route;
use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;
use Joomla\Plugin\System\Joomlab\Helper\LanguageHelper;

/** @var Joomla\Component\JLForm\Administrator\View\Form\HtmlView $this */

AssetHelper::getWebAssetManager()
    ->useScript('keepalive')
    ->useScript('form.validate')
    ->useScript('joomlab.tabs-state')
    ->usePreset('com_jlform.form-builder-init')
    ->usePreset('choicesjs');
$app         = Factory::getApplication();
$input       = $app->getInput();
$language    = $app->getLanguage()->getTag();
$proVersion  = PluginHelper::isEnabled('jlform', 'pro');
$buildConfig = [
    'language'       => $language,
    'languages'      => [$language],
    'strings'        => [],
    'packageLicence' => $proVersion ? 'Pro' : 'Free',
];

if (Multilanguage::isEnabled()) {
    $buildConfig['languages'] = LanguageHelper::getLanguageCodes();

    if ($buildConfig['languages'][0] !== $buildConfig['language']) {
        $modifyLanguages = [$buildConfig['language']];

        foreach ($buildConfig['languages'] as $langCode) {
            if (!in_array($langCode, $modifyLanguages)) {
                $modifyLanguages[] = $langCode;
            }
        }

        $buildConfig['languages'] = $modifyLanguages;
    }
}

$strings = [
    'COM_JLFORM_SAVE',
    'COM_JLFORM_CLOSE',
    'COM_JLFORM_CANCEL',
    'COM_JLFORM_CLEAN',
    'COM_JLFORM_DELETE',
    'COM_JLFORM_ADD_ROW',
    'COM_JLFORM_STEP_NUMBER',
    'COM_JLFORM_CONFIRM_DEL_STEP',
    'COM_JLFORM_CONFIRM_DEL_ROW',
    'COM_JLFORM_CONFIRM_CLEAN_FIELD',
    'COM_JLFORM_MESSAGE',
    'COM_JLFORM_HINT',
    'COM_JLFORM_MULTIPLE',
    'COM_JLFORM_LABEL',
    'COM_JLFORM_FIELD_SETTING',
    'COM_JLFORM_CONFIRM',
    'COM_JLFORM_SINGLE',
    'COM_JLFORM_RANGE',
    'COM_JLFORM_NUMBER_OF_CALENDAR',
    'COM_JLFORM_ITEMS',
    'COM_JLFORM_FORMAT',
    'COM_JLFORM_INTEGER',
    'COM_JLFORM_MINIMUM',
    'COM_JLFORM_MAXIMUM',
    'COM_JLFORM_TEXT',
    'COM_JLFORM_EMAIL',
    'COM_JLFORM_NUMBER',
    'COM_JLFORM_FILE_TYPE',
    'COM_JLFORM_FILE_MAX_SIZE',
    'COM_JLFORM_ADD_STEP',
    'COM_JLFORM_REQUIRED',
    'COM_JLFORM_ROWS',
    'COM_JLFORM_COLS',
    'COM_JLFORM_LABEL_REQUIRED_WARN',
    'COM_JLFORM_ENTER_STEP_TITLE',
    'COM_JLFORM_EDIT_STEP_TITLE',
    'COM_JLFORM_NO_DATA_WARN',
    'COM_JLFORM_FORMAT_24H',
    'COM_JLFORM_MIN_DATE',
    'COM_JLFORM_MAX_DATE',
    'COM_JLFORM_DAYS_FROM_NOW',
    'COM_JLFORM_YEAR',
    'COM_JLFORM_MONTH',
    'COM_JLFORM_DATE',
    'COM_JLFORM_FREE_TEXT',
    'COM_JLFORM_REGEX_PATTERN',
    'COM_JLFORM_TEXT_HTML',
    'COM_JLFORM_NAME',
    'COM_JLFORM_AUTO_GENERATE_FROM_LABEL',
    'COM_JLFORM_LBL_ATTRS',
    'COM_JLFORM_CTRL_ATTRS',
    'COM_JLFORM_NATIVE_NAME',
    'COM_JLFORM_BOTH',
    'COM_JLFORM_DISPLAY',
    'COM_JLFORM_LBL_YES',
    'COM_JLFORM_LBL_NO',
    'COM_JLFORM_DATE_FORMAT',
    'COM_JLFORM_DISPLAY_INLINE',
    'COM_JLFORM_FIELD_NAME_NOTE',
    'COM_JLFORM_SEND_EMAIL',
    'COM_JLFORM_EMAIL_ATTACHMENT',
    'COM_JLFORM_SHOW_ON',
    'COM_JLFORM_COLUMNS13',
    'COM_JLFORM_DEFAULT_VALUE',
];

foreach ($strings as $string) {
    $camelCases = [];

    foreach (explode('_', strtolower(str_replace('COM_JLFORM_', '', $string))) as $i => $str) {
        $camelCases[] = $i ? strtoupper($str[0]) . substr($str, 1) : $str;
    }

    $buildConfig['strings'][implode($camelCases)] = Text::_($string);
}

$jsonConfig = json_encode($buildConfig);
$hasPlugins = $this->getModel()->setState('form.hasPlugins');
?>
<form action="<?php echo Route::_('index.php?option=com_jlform&layout=edit&id=' . (int)$this->item->id, false); ?>"
      method="post" name="adminForm" id="item-form"
      aria-label="<?php echo Text::_('COM_JLFORM_FORM_PAGE_TITLE_' . ((int)$this->item->id === 0 ? 'ADD_FORM' : 'EDIT_FORM'), true); ?>"
      class="form-validate jl-scope">
    <div class="uk-grid uk-grid-small title-alias form-vertical uk-margin">
        <div class="uk-width-1-2@s uk-width-2-3@m">
            <?php echo $this->form->renderField('title'); ?>
        </div>
        <div class="uk-width-1-2@s uk-width-1-3@m">
            <?php echo $this->form->renderField('state'); ?>
        </div>
    </div>

    <div class="uk-card uk-card-default uk-card-body">
        <ul uk-tab>
            <li class="uk-active"><a href="#"><?php
                    echo Text::_('COM_JLFORM_TAB_GENERAL'); ?></a></li>
            <li><a href="#"><?php echo Text::_('COM_JLFORM_TAB_MAILER'); ?></a></li>
            <li><a href="#"><?php echo Text::_('COM_JLFORM_TAB_CUSTOM'); ?></a></li>

            <?php if ($hasPlugins): ?>
                <li><a href="#"><?php echo Text::_('COM_JLFORM_TAB_PLUGINS'); ?></a></li>
            <?php endif; ?>
        </ul>
        <ul class="uk-switcher uk-margin">
            <li>
                <div class="uk-grid-small uk-grid-divider" uk-grid>
                    <div class="uk-width-1-2@m uk-width-2-3@l">
                        <div id="jl-form-builder"
                             data-form-target="#<?php echo $this->form->getField('data')->id; ?>"
                             data-form-config="<?php echo htmlspecialchars($jsonConfig); ?>"></div>
                    </div>
                    <div class="uk-width-1-2@m uk-width-1-3@l">
                        <?php echo $this->form->renderFieldset('basic'); ?>
                    </div>
                </div>
            </li>
            <li>
                <?php echo $this->form->renderFieldset('mailer'); ?>
            </li>
            <li>
                <?php echo $this->form->renderFieldset('custom'); ?>
            </li>
            <?php if ($hasPlugins): ?>
                <li>
                    <?php echo $this->form->renderFieldset('plugins'); ?>
                </li>
            <?php endif; ?>
        </ul>


        <div class="hidden">
            <?php echo $this->form->getInput('id'); ?>
            <?php echo $this->form->getInput('data'); ?>
            <input type="hidden" name="task" value="">
            <input type="hidden" name="return" value="<?php echo $input->getBase64('return'); ?>">
            <?php echo HTMLHelper::_('form.token'); ?>
        </div>
    </div>
</form>
