<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;
use Joomla\Component\JLForm\Site\Helper\FormHelper;
use Joomla\Plugin\System\Joomlab\Helper\AssetHelper;
use Joomla\Registry\Registry;


/**
 * @var  $displayData array
 * @var  $options     Registry
 * @var  $formParams  Registry
 * @var  $name        string
 */

extract($displayData);

$isBootstrapLayout                 = $formParams->get('formLayout', 'bootstrap') === 'bootstrap';
$ctrlClass                         = $isBootstrapLayout ? 'form-select' : 'uk-select';
$ctrlSmallClass                    = $isBootstrapLayout ? 'form-select-sm' : 'uk-form-small';
$ctrlLargeClass                    = $isBootstrapLayout ? 'form-select-lg' : 'uk-form-large';
$displayData['ctrlAttrs']['class'] .= ' ' . $ctrlClass . ($formParams->get('controlSize') === 'small' ? ' ' . $ctrlSmallClass : ($formParams->get('controlSize') === 'large' ? ' ' . $ctrlLargeClass : ''));

if ($options->get('multiple')) {
    $displayData['ctrlAttrs']['multiple'] = '';
}

$items = $options->get('items');

$config            = ComponentHelper::getParams('com_jlform');
$useWebComponent   = (bool)$config->get('useWebComponentFancySelect', 1);
$minimumItems      = (int)$config->get('minItemsToUseWebComponentFancySelect', 25);
$startWebComponent = '';
$endWebComponent   = '';

if ($useWebComponent && ($minimumItems < 1 || count($items) >= $minimumItems)) {
    Text::script('JGLOBAL_SELECT_NO_RESULTS_MATCH');
    Text::script('JGLOBAL_SELECT_PRESS_TO_SELECT');

    AssetHelper::getWebAssetManager()
        ->usePreset('choicesjs')
        ->useScript('webcomponent.field-fancy-select');


    $attr = 'placeholder="' . htmlspecialchars(Text::_('JGLOBAL_TYPE_OR_SELECT_SOME_OPTIONS')) . '"';

    if (isset($displayData['ctrlAttrs']['required'])) {
        $attr .= ' required';
    }

    $startWebComponent = '<joomla-field-fancy-select ' . $attr . '>';
    $endWebComponent   = '</joomla-field-fancy-select>';
}

echo $startWebComponent;


$value = $displayData['value'] ?? null;

if ($value && !is_array($value)) {
    $value = [$value];
}

?>
    <select name="<?php echo $name; ?>"<?php echo FormHelper::buildAttributes($displayData['ctrlAttrs']); ?>>
        <?php foreach ($items as $item) :
            $checked = $value ? in_array($item['value'], $value) : $item['isDefault'];
            ?>
            <option value="<?php echo htmlspecialchars($item['value']); ?>"<?php echo $checked ? ' selected' : ''; ?>>
                <?php echo htmlspecialchars($item['text']); ?>
            </option>
        <?php endforeach; ?>
    </select>

<?php

echo $endWebComponent;