<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\Component\JLForm\Site\Helper\FormHelper;
use Joomla\Registry\Registry;

/**
 * @var  $displayData array
 * @var  $options     Registry
 * @var  $formParams  Registry
 */

extract($displayData);
$id                = $displayData['ctrlAttrs']['id'] . '-toggle';
$horizontal        = $options->get('horizontal');
$isBootstrapLayout = $formParams->get('formLayout', 'bootstrap') === 'bootstrap';
unset($displayData['ctrlAttrs']['id']);

$lblYes = (array)$options->get('lblYes', []);
$lblNo  = (array)$options->get('lblNo', []);

if (($displayData['value'] ?? null) == '1' || $options->get('checked', false)) {
    $displayData['ctrlAttrs']['checked'] = '';
}
?>
<div class="jl-form__field-switcher">
    <input
            type="checkbox"
            name="<?php echo htmlspecialchars($name); ?>" id="<?php echo $id; ?>"
            value="1"
        <?php echo FormHelper::buildAttributes($displayData['ctrlAttrs']); ?>/>
    <label for="<?php echo $id; ?>">
        <span class="jl-form__field-switcher__slider round"></span>
    </label>
    <div class="jl-form__field-switcher__hint <?php echo $isBootstrapLayout ? 'form-text' : 'uk-text-meta'; ?>"
         data-lbl-yes="<?php echo htmlspecialchars(FormHelper::_($lblYes)); ?>"
         data-lbl-no="<?php echo htmlspecialchars(FormHelper::_($lblNo)); ?>">
        <?php echo FormHelper::_($lblNo); ?>
    </div>
</div>
