<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/** @var $displayData array */

?>

<div class="jl-form__row jl-form__row<?php echo $displayData['index']; ?> uk-grid-small" uk-grid>
    <?php

    foreach ($displayData['options'] as $column) {
        $colClass = 'uk-width-';

        switch ($column['size']) {
            case 12:
                $colClass .= '1-1';
                break;

            case 8:
                $colClass .= '3-4';
                break;

            case 6:
                $colClass .= '1-2';
                break;

            case 4:
                $colClass .= '1-3';
                break;

            case 3:
                $colClass .= '1-4';
                break;

            case 0:
                $colClass .= 'auto';
                break;

            case -1:
                $colClass .= 'expand';
                break;
        }

        $colClass .= '@m';

        echo '<div class="jl-form__col ' . $colClass . '">' . implode(PHP_EOL, $column['fields']) . '</div>';
    }

    ?>

</div>
