<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;

extract($displayData);
$app             = Factory::getApplication();
$user            = $app->getIdentity();
$isAdmin         = $app->isClient('administrator');
$canEdit         = $isAdmin && $user->authorise('core.edit', 'com_jlform');
$canDelete       = $isAdmin && $user->authorise('core.delete', 'com_jlform');

?>
<?php if ($replies): ?>
    <?php foreach ($replies as $reply):
        $limit = 1024;
        $summary = mb_substr($reply->content, 0, $limit);

        if (mb_strlen($summary) < mb_strlen($reply->content)) {
            $summary .= '... <a class="jl-form__submission-reply-content__view-more uk-link-reset" href="#"><small>'
                . strtolower(Text::_('COM_JLFORM_SUBMISSION_REPLY_VIEW_MORE')) . '</small></a>';
        }

        ?>
        <article class="jl-form__submission-reply-container uk-margin-small-top uk-padding-small uk-comment<?php echo $user->id == $reply->createdBy ? ' uk-comment-primary' : ''; ?>" role="comment">
            <header class="uk-comment-header">
                <ul class="uk-comment-meta uk-subnav uk-subnav-divider uk-margin-remove-top">
                    <li><span uk-icon="user"></span> <?php echo ucfirst($reply->authorName ?: Text::_('COM_JLFORM_SUBMISSION_REPLY_AUTHOR_GUEST')); ?></li>
                    <li>
                        <span uk-icon="calendar"></span> <?php echo HTMLHelper::_('date.relative', $reply->createdDate) ?>
                    </li>
                </ul>
            </header>
            <div class="uk-comment-body">
                <div class="uk-grid-small" uk-grid>
                    <p class="jl-form__submission-reply-content uk-width-expand" data-reply-content="<?php echo htmlspecialchars($reply->content); ?>">
                        <?php echo preg_replace('/\r\n|\n/', '<br>', $summary); ?>
                    </p>
                    <ul class="uk-comment-meta uk-subnav uk-subnav-divider uk-width-auto">
                        <?php if ($canEdit || $reply->createdBy == $user->id): ?>
                            <li>
                                <a class="jl-form__submission-reply-edit" data-reply-id="<?php echo $reply->id; ?>" href="#"><span uk-icon="pencil"></span></a>
                            </li>
                        <?php endif; ?>
                        <?php if ($canDelete || $reply->createdBy == $user->id): ?>
                            <li>
                                <a class="jl-form__submission-reply-delete" data-reply-id="<?php echo $reply->id; ?>" href="#"><span uk-icon="trash"></span></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>

            </div>
        </article>
    <?php endforeach; ?>
    <div class="uk-margin-small-top uk-flex uk-flex-middle uk-flex-right">
        <div class="uk-margin-small-right"><?php echo $pagination->getResultsCounter(); ?> </div>
        <nav>
            <ul class="uk-iconnav">
                <li>
                    <a class="uk-icon-button jl-form__submission-reply__pagination-prev<?php echo $pagination->limitstart ? '' : ' uk-disabled'; ?>" href="#" uk-icon="icon: chevron-left"></a>
                </li>
                <li>
                    <a class="uk-icon-button uk-margin-auto-left jl-form__submission-reply__pagination-next<?php echo $pagination->pagesCurrent == $pagination->pagesStop ? ' uk-disabled' : ''; ?>"
                       uk-icon="icon: chevron-right" href="#"></a>
                </li>
            </ul>
        </nav>
    </div>

<?php endif; ?>