<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Controller;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;

class DisplayController extends BaseController
{
    public function __construct($config = [], ?MVCFactoryInterface $factory = null, $app = null, $input = null)
    {
        $app  = Factory::getApplication();
        $view = $app->getInput()->get('view');

        if (in_array($view, ['submission', 'submissions'])) {
            $config['base_path'] = JPATH_ADMINISTRATOR . '/components/com_jlform';
            $app->getLanguage()->load('com_jlform', $config['base_path']);
        }

        parent::__construct($config, $factory, $app, $input);
    }

    public function display($cachable = false, $urlparams = false)
    {
        $user          = $this->app->getIdentity();
        $cachable      = !$user->id && $this->input->getMethod() === 'GET';
        $safeurlparams = [
            'id'     => 'INT',
            'lang'   => 'CMD',
            'Itemid' => 'INT',
        ];

        parent::display($cachable, $safeurlparams);

        return $this;
    }
}
