<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Event;

defined('_JEXEC') or die;

use Joomla\Component\JLForm\Administrator\Table\SubmissionTable;

class AfterSubmitEvent extends FormEvent
{
    public function __construct(array $arguments = [])
    {
        parent::__construct(static::AFTER_SUBMIT, $arguments);
    }

    public function getSubmission(): SubmissionTable
    {
        return $this->getArgument('submission');
    }

    public function getRedirect(): ?string
    {
        return $this->getArgument('redirect');
    }
}
