<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Event;

defined('_JEXEC') or die;

use Joomla\Component\JLForm\Administrator\Table\SubmissionPaymentTable;
use Joomla\Component\JLForm\Administrator\Table\SubmissionTable;
use Joomla\Event\Event;
use stdClass;

class PaymentEvent extends Event
{
    public function getForm(): stdClass
    {
        return $this->getArgument('subject');
    }

    public function getSubmission(): SubmissionTable
    {
        return $this->getArgument('submission');
    }

    public function getPayment(): SubmissionPaymentTable
    {
        return $this->getArgument('payment');
    }

    public function getPaymentName(): string
    {
        return $this->getPayment()->name;
    }
}
