<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Helper\FieldValidator;

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\Component\JLForm\Site\Helper\FieldValidator;
use Joomla\Plugin\System\Joomlab\Helper\UtilityHelper;

class CountryField extends FieldValidator
{
    protected function doValidate(&$value)
    {
        $disableCodes = $this->options->get('disableCodes', []);
        $countries    = UtilityHelper::getCountriesList();
        $validCodes   = [];

        foreach ($countries as $country) {
            if (in_array($country['code'], $disableCodes)) {
                continue;
            }

            $validCodes[] = $country['code'];
        }

        $slicedCodes = implode(', ', array_slice($validCodes, 0, 5)) . '...';

        if ($this->options->get('multiple')) {
            if (!is_array($value)) {
                $this->addError(Text::_('COM_JLFORM_ERR_FIELD_INVALID_ARRAY_MSG'));

                return false;
            }

            foreach ($value as $val) {
                if (!in_array($val, $validCodes, true)) {
                    $this->addError(Text::sprintf('COM_JLFORM_ERR_FIELD_INVALID_LIST_VALUE_MSG', $slicedCodes));
                    break;
                }
            }
        } elseif (!in_array($value, $validCodes, true)) {
            $this->addError(Text::sprintf('COM_JLFORM_ERR_FIELD_INVALID_LIST_VALUE_MSG', $slicedCodes));
        }
    }
}
