<?php

/**
 * @package     Joomlab
 * @subpackage  com_jlform
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Component\JLForm\Site\Model;

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\ItemModel;
use Joomla\Database\ParameterType;
use Joomla\Registry\Registry;
use RuntimeException;

class FormModel extends ItemModel
{
    public function getItem($pk = null)
    {
        $pk = (int)($pk ?: $this->getState('form.id'));

        if (empty($pk)) {
            throw new RuntimeException(Text::_('COM_JLFORM_ERROR_INVALID_FORM_ID'), 404);
        }

        if ($this->_item === null) {
            $this->_item = [];
        }

        if (!isset($this->_item[$pk])) {
            $db    = $this->getDatabase();
            $query = $db->getQuery(true);

            $query->select(
                $this->getState(
                    'item.select',
                    [
                        $db->quoteName('a.id'),
                        $db->quoteName('a.state'),
                        $db->quoteName('a.title'),
                        $db->quoteName('a.description'),
                        $db->quoteName('a.data'),
                        $db->quoteName('a.params'),
                        $db->quoteName('a.plugins'),
                        $db->quoteName('a.createdBy'),
                        $db->quoteName('a.createdDate'),
                        $db->quoteName('a.modifiedBy'),
                        $db->quoteName('a.modifiedDate'),
                        $db->quoteName('a.checkedOut'),
                        $db->quoteName('a.checkedOutTime'),
                    ]
                )
            )
                ->select(
                    [
                        $db->quoteName('u.name', 'author'),
                    ]
                )
                ->from($db->quoteName('#__joomlab_forms', 'a'))
                ->join(
                    'LEFT',
                    $db->quoteName('#__users', 'u'),
                    $db->quoteName('u.id') . ' = ' . $db->quoteName('a.createdBy')
                )
                ->where(
                    [
                        $db->quoteName('a.id') . ' = :pk',
                        $db->quoteName('a.state') . ' = 1',
                    ]
                )
                ->bind(':pk', $pk, ParameterType::INTEGER);


            $db->setQuery($query);
            $form = $db->loadObject();

            if (empty($form)) {
                throw new RuntimeException(Text::_('COM_JLFORM_ERROR_FORM_NOT_FOUND'), 404);
            }

            $form->data    = (new Registry($form->data))->toArray();
            $form->params  = new Registry($form->params);
            $form->plugins = new Registry($form->plugins);
            $terms         = '';

            switch ($form->params->get('termsAndConditions')) {
                case 'articleId':

                    if ($articleId = $form->params->get('tncArticleId')) {
                        $query->clear()
                            ->select($db->quoteName(['introtext', 'fulltext']))
                            ->from($db->quoteName('#__content'))
                            ->where($db->quoteName('id') . ' = :id AND state = 1')
                            ->bind(':id', $articleId);

                        if ($article = $db->setQuery($query)->loadObject()) {
                            $terms = trim($article->introtext . $article->fulltext);
                        }
                    }

                    break;

                case 'text':
                    $terms = trim($form->params->get('tncText', ''));
                    break;
            }

            $form->termsAndConditions = $terms;
            $this->_item[$pk]         = $form;
        }

        return $this->_item[$pk];
    }

    protected function populateState()
    {
        $app = Factory::getApplication();

        // Load state from the request.
        $pk = $app->getInput()->getUint('id');
        $this->setState('form.id', $pk);
    }
}
