class JLFormShowOn {
    constructor(cont) {
        const self = this;
        this.container = cont || document;
        this.fields = {
            // origin-field-name: {
            //   origin:  ['collection of all the trigger nodes'],
            //   targets: ['collection of nodes to be controlled control']
            // }
        };
        this.showonFields = this.container.querySelectorAll('.jl-form__field-container [data-show-on]');
        // Populate the fields data
        if (this.showonFields.length) {
            this.showonFields.forEach(field => {
                // Set up only once
                if (field.hasAttribute('data-show-on-initialised')) {
                    return;
                }

                field.setAttribute('data-show-on-initialised', '')

                const jsonData = field.getAttribute('data-show-on') || '';
                const showOnData = JSON.parse(jsonData);
                let localFields;

                if (showOnData.length) {
                    localFields = self.container.querySelectorAll(`[name="JLForm[${showOnData[0].field}]"], [name="JLForm[${showOnData[0].field}][]"]`);
                    if (!this.fields[showOnData[0].field]) {
                        this.fields[showOnData[0].field] = {
                            origin: [],
                            targets: []
                        };
                    }

                    // Add trigger elements
                    localFields.forEach(cField => {
                        if (this.fields[showOnData[0].field].origin.indexOf(cField) === -1) {
                            this.fields[showOnData[0].field].origin.push(cField);
                        }
                    });

                    // Add target elements
                    this.fields[showOnData[0].field].targets.push(field);

                    // Data showon can have multiple values
                    if (showOnData.length > 1) {
                        showOnData.forEach((value, index) => {
                            if (index === 0) {
                                return;
                            }

                            localFields = self.container.querySelectorAll(`[name="JLForm[${value.field}]"], [name="JLForm[${value.field}][]"]`);

                            if (!this.fields[showOnData[0].field]) {
                                this.fields[showOnData[0].field] = {
                                    origin: [],
                                    targets: []
                                };
                            }

                            // Add trigger elements
                            localFields.forEach(cField => {
                                if (this.fields[showOnData[0].field].origin.indexOf(cField) === -1) {
                                    this.fields[showOnData[0].field].origin.push(cField);
                                }
                            });

                            // Add target elements
                            if (this.fields[showOnData[0].field].targets.indexOf(field) === -1) {
                                this.fields[showOnData[0].field].targets.push(field);
                            }
                        });
                    }
                }
            });

            // Do some binding
            this.linkedOptions = this.linkedOptions.bind(this);

            // Attach events to referenced element, to check condition on change and keyup
            Object.keys(this.fields).forEach(key => {
                if (this.fields[key].origin.length) {
                    this.fields[key].origin.forEach(elem => {
                        // Initialize the showon behaviour for the given HTMLElement
                        self.linkedOptions(key);

                        // Setup listeners
                        elem.addEventListener('change', () => {
                            self.linkedOptions(key);
                        });
                        elem.addEventListener('keyup', () => {
                            self.linkedOptions(key);
                        });
                        elem.addEventListener('click', () => {
                            self.linkedOptions(key);
                        });
                    });
                }
            });
        }
    }

    /**
     *
     * @param key
     */
    linkedOptions(key) {
        // Loop through the elements that need to be either shown or hidden
        this.fields[key].targets.forEach(field => {
            const elementshowOnDatas = JSON.parse(field.getAttribute('data-show-on')) || [];
            let showField = true;
            let itemVal;

            // Check if target conditions are satisfied
            elementshowOnDatas.forEach((elementshowOnData, index) => {
                const condition = elementshowOnData || {};
                condition.valid = 0;

                // Test in each of the elements in the field array if condition is valid
                this.fields[key].origin.forEach(originField => {
                    const singleName = originField.name.replace('[]', '');

                    if (singleName !== `JLForm[${elementshowOnData.field}]`) {
                        return;
                    }

                    const originId = originField.id;
                    const isSelect = originField.tagName.toLowerCase() === 'select';
                    const type = (originField.getAttribute('type') || '').toLowerCase()

                    // If checkbox or radio box the value is read from properties
                    if (['checkbox', 'radio'].includes(type)) {
                        itemVal = [];

                        if (type === 'checkbox') {
                            if (originField.classList.contains('jl-form__field--Switcher')) {
                                itemVal.push(originField.checked ? originField.value : '');
                            } else {
                                this.container.querySelectorAll(`[name="${originField.name}"]`).forEach(chb => {
                                    if (chb.checked) {
                                        itemVal.push(chb.value);
                                    }
                                });
                            }
                        } else {
                            itemVal = this.container.querySelector(`[name="${originField.name}"]:checked`)?.value ?? null;
                            itemVal = itemVal === null ? [] : [itemVal];
                        }

                    } else if (isSelect && originField.hasAttribute('multiple')) {
                        itemVal = Array.from(originField.querySelectorAll('option:checked')).map(el => el.value);
                    } else {
                        // Select lists, text-area etc. Note that multiple-select list returns
                        // an Array here so we can always treat 'itemVal' as an array
                        itemVal = document.getElementById(originId).value;
                        // Check data attribute data-global instead of value in <select> for use global
                        if (isSelect) {
                            const selectedOption = document.getElementById(originId).selectedOptions[0];
                            if (selectedOption && 'globalValue' in selectedOption.dataset) {
                                itemVal = selectedOption.dataset.globalValue;
                            }
                        }
                        // A multi-select <select> $field  will return null when no elements are
                        // selected so we need to define itemVal accordingly
                        if (itemVal === null && isSelect) {
                            itemVal = [];
                        }
                    }

                    // Convert to array to allow multiple values in the field (e.g. type=list multiple)
                    // and normalize as string
                    if (!(typeof itemVal === 'object')) {
                        itemVal = JSON.parse(`["${itemVal}"]`);
                    }

                    // Test if any of the values of the field exists in showon conditions
                    itemVal.forEach(val => {
                        // ":" Equal to one or more of the values condition
                        if (condition.sign === '=' && condition.values.indexOf(val) !== -1) {
                            condition.valid = 1;
                        }

                        // "!:" Not equal to one or more of the values condition
                        if (condition.sign === '!=' && condition.values.indexOf(val) === -1) {
                            condition.valid = 1;
                        }
                    });

                });
                // Verify conditions
                // First condition (no operator): current condition must be valid
                if (condition.op === '') {
                    if (condition.valid === 0) {
                        showField = false;
                    }
                } else {
                    // Other conditions (if exists)
                    // AND operator: both the previous and current conditions must be valid
                    if (condition.op === 'AND' && condition.valid + elementshowOnDatas[index - 1].valid < 2) {
                        showField = false;
                        condition.valid = 0;
                    }
                    // OR operator: one of the previous and current conditions must be valid
                    if (condition.op === 'OR' && condition.valid + elementshowOnDatas[index - 1].valid > 0) {
                        showField = true;
                        condition.valid = 1;
                    }
                }

            });

            // If conditions are satisfied show the target field(s), else hide
            const rowContainer = field.closest('.jl-form__row');
            const fieldContainer = field.closest('.jl-form__field-container');
            // const colContainer = field.closest('.jl-form__col');

            if (field.tagName.toLowerCase() !== 'option') {
                if (showField) {
                    fieldContainer.removeAttribute('hidden');
                    fieldContainer.dispatchEvent(new CustomEvent('joomlab-form:show-on-show', {bubbles: true}));
                } else {
                    fieldContainer.setAttribute('hidden', '');
                    fieldContainer.dispatchEvent(new CustomEvent('joomlab-form:show-on-hide', {bubbles: true}));
                }

                if (rowContainer.querySelectorAll('.jl-form__field-container:not([hidden])').length) {
                    rowContainer.removeAttribute('hidden');
                } else {
                    rowContainer.setAttribute('hidden', '');
                }
            } else {
                // @todo: If chosen or choices.js is active we should update them
                field.disabled = !showField;
            }
        });
    }
}

document.addEventListener('DOMContentLoaded', () => new JLFormShowOn(document));
