<?php

/**
 * @package     Joomlab
 * @subpackage  com_mvitem
 * @copyright   Copyright (C) 2025 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Joomla\Plugin\System\Joomlab\MVC\View;

defined('_JEXEC') or die;

use Joomla\CMS\MVC\View\GenericDataException;
use Joomla\CMS\MVC\View\HtmlView;

class ItemView extends HtmlView
{
    protected $item;

    protected $state;

    public function display($tpl = null)
    {
        $model       = $this->getModel();
        $this->item  = $model->getItem();
        $this->state = $model->getState();

        // Check for errors.
        if (count($errors = $model->getErrors())) {
            throw new GenericDataException(implode(PHP_EOL, $errors), 500);
        }

        $this->addToolbar();
        parent::display($tpl);
    }

    protected function addToolbar() {}
}
